/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.vertex;

import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.api.vertex.VertexWriter;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;

public abstract class VertexWriterUnsafe<V extends VertexType>
implements VertexWriter {
    public final V type;
    protected final ByteBuffer buffer;
    private int totalVertices;
    private int writeVertex;
    protected long ptr;

    protected VertexWriterUnsafe(V type, ByteBuffer buffer) {
        this.type = type;
        this.buffer = buffer;
        this.ptr = MemoryUtil.memAddress((ByteBuffer)buffer);
    }

    protected void advance() {
        ++this.writeVertex;
        if (this.writeVertex > this.totalVertices) {
            this.totalVertices = this.writeVertex;
        }
    }

    @Override
    public void seekToVertex(int vertex) {
        this.buffer.position(this.type.byteOffset(vertex));
        this.writeVertex = vertex;
        this.ptr = MemoryUtil.memAddress((ByteBuffer)this.buffer);
    }

    @Override
    public VertexList intoReader() {
        return this.type.createReader(this.buffer, this.totalVertices);
    }
}

